/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.extension.incubator.metrics.HistogramAdviceConfigurer;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkLongHistogram;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkDoubleHistogram
extends AbstractInstrument
implements DoubleHistogram {
    private static final Logger logger = Logger.getLogger(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
        if (value < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    static final class SdkDoubleHistogramBuilder
    extends AbstractInstrumentBuilder<SdkDoubleHistogramBuilder>
    implements ExtendedDoubleHistogramBuilder,
    HistogramAdviceConfigurer {
        SdkDoubleHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, name, "", "");
        }

        @Override
        protected SdkDoubleHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkDoubleHistogramBuilder setAdvice(Consumer<HistogramAdviceConfigurer> adviceConsumer) {
            adviceConsumer.accept(this);
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }

        @Override
        public HistogramAdviceConfigurer setExplicitBucketBoundaries(List<Double> bucketBoundaries) {
            this.setAdvice(Advice.create(bucketBoundaries));
            return this;
        }
    }
}

