/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.BooleanValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class GraphqlBooleanCoercing
implements Coercing<Boolean, Boolean> {
    private Boolean convertImpl(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof String) {
            String lStr = ((String)input).toLowerCase();
            if (lStr.equals("true")) {
                return true;
            }
            if (lStr.equals("false")) {
                return false;
            }
            return null;
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return (Boolean)Assert.assertShouldNeverHappen();
            }
            return value.compareTo(BigDecimal.ZERO) != 0;
        }
        return null;
    }

    @NotNull
    private Boolean serializeImpl(@NotNull Object input, @NotNull Locale locale) {
        Boolean result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Boolean.notBoolean", CoercingUtil.typeName(input)));
        }
        return result;
    }

    @NotNull
    private Boolean parseValueImpl(@NotNull Object input, @NotNull Locale locale) {
        if (!(input instanceof Boolean)) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Boolean.unexpectedRawValueType", CoercingUtil.typeName(input)));
        }
        return (Boolean)input;
    }

    private static boolean parseLiteralImpl(@NotNull Object input, @NotNull Locale locale) {
        if (!(input instanceof BooleanValue)) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Boolean.unexpectedAstType", CoercingUtil.typeName(input)));
        }
        return ((BooleanValue)input).isValue();
    }

    @NotNull
    private BooleanValue valueToLiteralImpl(@NotNull Object input, @NotNull Locale locale) {
        Boolean result = Assert.assertNotNull(this.convertImpl(input), () -> CoercingUtil.i18nMsg(locale, "Boolean.notBoolean", CoercingUtil.typeName(input)));
        return BooleanValue.newBooleanValue(result).build();
    }

    @Override
    @Deprecated
    public Boolean serialize(@NotNull Object dataFetcherResult) {
        return this.serializeImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    @Nullable
    public Boolean serialize(@NotNull Object dataFetcherResult, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingSerializeException {
        return this.serializeImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public Boolean parseValue(@NotNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Boolean parseValue(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public Boolean parseLiteral(@NotNull Object input) {
        return GraphqlBooleanCoercing.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @Nullable
    public Boolean parseLiteral(@NotNull Value<?> input, @NotNull CoercedVariables variables, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseLiteralException {
        return GraphqlBooleanCoercing.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NotNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

