/*
 * Decompiled with CFR 0.152.
 */
package graphql.relay;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.relay.Connection;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@PublicApi
public class DefaultConnection<T>
implements Connection<T> {
    private final ImmutableList<Edge<T>> edges;
    private final PageInfo pageInfo;

    public DefaultConnection(List<Edge<T>> edges, PageInfo pageInfo) {
        this.edges = ImmutableList.copyOf((Collection)Assert.assertNotNull(edges, () -> "edges cannot be null"));
        this.pageInfo = Assert.assertNotNull(pageInfo, () -> "page info cannot be null");
    }

    @Override
    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultConnection that = (DefaultConnection)o;
        return Objects.equals(this.edges, that.edges) && Objects.equals(this.pageInfo, that.pageInfo);
    }

    public int hashCode() {
        return Objects.hash(this.edges, this.pageInfo);
    }

    public String toString() {
        return "DefaultConnection{edges=" + this.edges + ", pageInfo=" + this.pageInfo + '}';
    }
}

